# 🐕 推特养号助手 - 使用说明

> **作者微信**：hkkj2028  
> **脚本下载**：http://ergoubtc.vip/  
> **版本**：v1.0.0

---

## 📖 目录

1. [安装教程（重点）](#-安装教程重点)
2. [使用方法（重点）](#-使用方法重点)
3. [运行策略建议（重点）](#-运行策略建议重点)
4. [常见问题](#-常见问题)
5. [注意事项](#️-注意事项)

---

## 🎯 简介

**推特养号助手**是一个Chrome浏览器插件，可以自动浏览、点赞、关注、转发Twitter/X内容，模拟真实用户行为，提升账号活跃度。

**核心功能**：
- 🔄 智能浏览推文（10-200条）
- ❤️ 自动点赞（0-50条）
- 👤 自动关注用户（0-20人）
- 🔁 自动转发（0-20条）
- ⏱️ 时长控制（5-120分钟）

**插件优势**：解决了页面跳转导致脚本停止的问题，支持自动恢复运行。

---

## 📦 安装教程（重点）

### 📋 安装前准备

**需要的东西**：
- ✅ Chrome浏览器（或Edge浏览器）
- ✅ 插件文件夹（chrome_extension）
- ✅ Twitter/X账号

**检查文件是否完整**：
打开 `chrome_extension` 文件夹，确认有以下文件：
```
chrome_extension/
├── manifest.json          ✔️ 配置文件
├── background.js          ✔️ 后台脚本
├── content.js            ✔️ 内容脚本  
├── popup.html            ✔️ 界面文件
├── popup.js              ✔️ 界面脚本
└── icons/                ✔️ 图标文件夹
    ├── icon16.png        （必需）
    ├── icon32.png        （必需）
    ├── icon48.png        （必需）
    └── icon128.png       （必需）
```

> ⚠️ **重要**：如果缺少 icons 文件夹或图标文件，插件将无法安装！

---

### 🔧 详细安装步骤

#### 第1步：打开Chrome扩展管理页面

**方法一（推荐）**：
1. 在Chrome地址栏输入：`chrome://extensions/`
2. 按回车键

**方法二**：
1. 点击浏览器右上角的三个点（⋮）
2. 选择"更多工具"
3. 选择"扩展程序"

---

#### 第2步：开启开发者模式

1. 在扩展程序页面，找到右上角的"开发者模式"开关
2. 点击开关，使其变为**蓝色**（开启状态）

> 💡 如果看不到"开发者模式"，可能是因为页面没有完全加载，刷新一下页面

---

#### 第3步：加载插件

1. 开启开发者模式后，页面左上角会出现三个按钮
2. 点击**"加载已解压的扩展程序"**按钮
3. 在弹出的文件选择窗口中，找到并选择 `chrome_extension` **文件夹**
4. 点击**"选择文件夹"**（或"打开"）按钮

> ⚠️ **注意**：要选择整个文件夹，不是文件夹里的某个文件！

---

#### 第4步：确认安装成功

安装成功后，您会看到：

1. **扩展列表中出现插件**
   - 名称：推特养号助手
   - 图标：柴犬头像
   - 状态：已启用（蓝色开关）

2. **浏览器工具栏显示图标**
   - 柴犬图标会出现在浏览器右上角

**如果安装失败**：
- ❌ 提示"找不到图标"：检查 icons 文件夹是否存在
- ❌ 提示"manifest错误"：检查文件是否完整
- ❌ 看不到插件：刷新页面或重启浏览器

---

#### 第5步：固定插件到工具栏（可选但推荐）

1. 点击浏览器工具栏右侧的**拼图图标**（扩展程序）
2. 在下拉列表中找到"推特养号助手"
3. 点击旁边的**📌图钉图标**

这样插件图标就会一直显示在工具栏上，方便使用。

---

#### 第6步：测试插件

1. 访问Twitter主页：`https://twitter.com/home` 或 `https://x.com/home`
2. 登录您的Twitter账号
3. 点击工具栏中的**柴犬图标**
4. 应该会弹出配置界面

**看到配置界面 = 安装成功！🎉**

---

### 🆘 安装问题排查

#### 问题1：无法加载扩展
**错误提示**：`Couldn't load icon 'icons/icon16.png'`

**解决方法**：
1. 确认 `icons` 文件夹存在
2. 确认里面有4个图标文件（icon16.png、icon32.png、icon48.png、icon128.png）
3. 重新加载插件

---

#### 问题2：插件列表看不到
**解决方法**：
1. 刷新扩展程序页面（F5）
2. 重启Chrome浏览器
3. 重新执行安装步骤

---

#### 问题3：点击图标没反应
**解决方法**：
1. 确保在Twitter页面使用（twitter.com 或 x.com）
2. 刷新Twitter页面
3. 检查插件是否启用（蓝色开关）

---

## 🚀 使用方法（重点）

### 🎯 第一次使用（3分钟快速上手）

#### 步骤1：打开Twitter并登录
1. 访问 `https://twitter.com/home` 或 `https://x.com/home`
2. 确保已登录您的Twitter账号
3. 等待页面完全加载

#### 步骤2：打开插件
1. 点击浏览器工具栏的**柴犬图标**
2. 弹出配置界面

#### 步骤3：检查默认配置
插件已经设置好了安全的默认参数：
```
✅ 浏览推文数：60条
✅ 养号时长：20分钟
✅ 点赞数量：5条
✅ 关注数量：3人
✅ 转发数量：2条
✅ 所有功能：已启用
```

> 💡 **新手建议**：第一次使用建议使用默认配置，熟悉后再调整

#### 步骤4：开始运行
1. 点击**"🚀 开始养号"**按钮
2. 插件开始自动运行
3. 保持Twitter标签页在后台（可以切换到其他标签页）

#### 步骤5：监控进度（可选）
打开插件可以看到：
- ⏱️ 剩余时间倒计时
- 📊 实时操作统计
- 📝 详细操作记录

#### 步骤6：完成或停止
- **自动完成**：到达设定时长后自动停止
- **手动停止**：点击**"⏹️ 停止养号"**按钮

---

### ⚙️ 参数配置说明

#### 📊 养号参数

| 参数 | 范围 | 默认值 | 说明 |
|------|------|--------|------|
| **浏览推文数** | 10-200条 | 60条 | 浏览多少条推文 |
| **养号时长** | 5-120分钟 | 20分钟 | 运行总时长 |
| **点赞数量** | 0-50条 | 5条 | 自动点赞数量 |
| **关注数量** | 0-20人 | 3人 | 自动关注数量 |
| **转发数量** | 0-20条 | 2条 | 自动转发数量 |

#### 🎛️ 功能开关

- ☑️ **启用浏览功能** - 浏览和滚动推文（建议保持开启）
- ☑️ **启用点赞功能** - 自动点赞推文
- ☑️ **启用关注功能** - 自动关注用户
- ☑️ **启用转发功能** - 自动转发推文

**常用组合**：
- 🟢 **只浏览**：只开启浏览功能
- 🟡 **保守模式**：浏览 + 点赞
- 🟠 **标准模式**：浏览 + 点赞 + 关注
- 🔴 **完整模式**：开启所有功能

#### 💾 保存配置

- 调整好参数后点击**"💾 保存配置"**
- 配置会保存到浏览器
- 下次打开自动加载上次的设置

---

## 💡 运行策略建议（重点）

### 📋 推荐配置方案

#### 🔰 方案1：新账号养号（最推荐）

**适用场景**：新注册的账号，需要逐步建立活跃度

| 参数 | 设置 |
|------|------|
| 浏览推文数 | **60条** |
| 养号时长 | **20分钟** |
| 点赞数量 | **3条** |
| 关注数量 | **2人** |
| 转发数量 | **1条** |
| 功能开关 | **全部启用** |
| 运行频率 | **每天1-2次** |
| 运行时段 | **上午10点、下午3点** |

> ⭐ **特别提示**：新账号前3天建议只浏览不点赞，第4天开始逐步增加互动

---

#### 🟢 方案2：保守模式（安全第一）

**适用场景**：担心被检测，追求最大安全性

| 参数 | 设置 |
|------|------|
| 浏览推文数 | **80-100条** |
| 养号时长 | **25-30分钟** |
| 点赞数量 | **2-3条** |
| 关注数量 | **1人** |
| 转发数量 | **0条** |
| 功能开关 | **浏览+点赞+关注** |
| 运行频率 | **每天1次** |
| 运行时段 | **固定时间（如下午3点）** |

> 🛡️ **安全指数**：⭐⭐⭐⭐⭐（最安全）

---

#### 🟡 方案3：标准模式（日常维护）

**适用场景**：账号已有一定年龄，需要日常维护活跃度

| 参数 | 设置 |
|------|------|
| 浏览推文数 | **80条** |
| 养号时长 | **25分钟** |
| 点赞数量 | **5条** |
| 关注数量 | **3人** |
| 转发数量 | **2条** |
| 功能开关 | **全部启用** |
| 运行频率 | **每天2次** |
| 运行时段 | **上午10点、下午4点** |

> ⚖️ **平衡型**：安全性和效果兼顾

---

#### 🟠 方案4：积极模式（快速互动）

**适用场景**：老账号，希望快速提升互动数据

| 参数 | 设置 |
|------|------|
| 浏览推文数 | **100条** |
| 养号时长 | **30分钟** |
| 点赞数量 | **8-10条** |
| 关注数量 | **5人** |
| 转发数量 | **3条** |
| 功能开关 | **全部启用** |
| 运行频率 | **每天2-3次** |
| 运行时段 | **上午、下午、晚上各一次** |

> ⚠️ **风险提示**：激进模式，建议仅在成熟账号使用

---

#### 🔵 方案5：仅浏览模式

**适用场景**：只想提升浏览数据，不做任何互动

| 参数 | 设置 |
|------|------|
| 浏览推文数 | **100-150条** |
| 养号时长 | **30分钟** |
| 点赞数量 | **0条** |
| 关注数量 | **0人** |
| 转发数量 | **0条** |
| 功能开关 | **仅浏览** |
| 运行频率 | **不限制** |

> 📖 **最安全**：几乎无风险

---

### ⏰ 运行时间建议

#### 🟢 最佳运行时段
- **上午**：9:00 - 11:00
- **下午**：15:00 - 17:00
- **晚上**：20:00 - 22:00

#### 🔴 避免运行时段
- **凌晨**：0:00 - 6:00（异常时段）
- **深夜**：23:00 - 24:00（不自然）

#### 📅 运行频率规则
- ✅ **两次运行间隔**：至少3小时
- ✅ **每日运行次数**：不超过3次
- ✅ **每周休息**：每周1-2天不运行

---

### 📊 根据账号状态选择

#### 🆕 新账号（注册少于30天）
- **推荐方案**：方案1（新账号养号）或方案2（保守模式）
- **特别注意**：
  - 前3天只浏览不互动
  - 第1周每天最多运行1次
  - 第2周可增加到每天2次
  - 避免频繁更换IP

#### 🔰 中等账号（30-180天）
- **推荐方案**：方案3（标准模式）
- **可以尝试**：方案4（积极模式），但需观察账号状态

#### 🏆 老账号（超过180天）
- **推荐方案**：方案3或方案4
- **更灵活**：可根据需求调整，风险相对较低

---

### 🎯 使用技巧

#### 1️⃣ 分段养号策略
**目标**：模拟真实用户全天活动

| 时段 | 时间 | 配置 | 目的 |
|------|------|------|------|
| **早晨** | 9:00-10:00 | 浏览为主（点赞1-2条） | 晨间浏览 |
| **下午** | 15:00-16:00 | 标准配置 | 活跃时段 |
| **晚上** | 20:00-21:00 | 完整功能 | 黄金时段 |

#### 2️⃣ 页面选择
- ✅ **推荐**：`https://twitter.com/home`（首页时间线）
- ✅ **可用**：Following页面、列表页面
- ❌ **避免**：个人主页、搜索结果页

#### 3️⃣ 配合手动操作
**最佳实践**：自动化 + 手动操作结合
- 运行插件前：手动浏览1-2分钟
- 运行插件后：手动发1-2条推文
- 每天至少：进行3-5次真实互动

#### 4️⃣ 监控账号状态
**定期检查**（每3天）：
- 查看是否收到Twitter官方邮件警告
- 检查功能是否受限（点赞、关注按钮是否正常）
- 观察粉丝增长是否异常

**异常处理**：
- 🟡 收到警告 → 立即停止使用1-2周
- 🔴 功能受限 → 停止使用，等待恢复
- 🟢 一切正常 → 继续使用，可适当增加频率

---

## ❓ 常见问题

### Q1：插件无法启动？

**可能原因**：
- ❌ 不在Twitter页面
- ❌ 插件未启用
- ❌ 页面未完全加载

**解决方法**：
1. 确认在 `twitter.com` 或 `x.com` 页面
2. 刷新页面等待完全加载
3. 检查插件是否启用（chrome://extensions/）
4. 重新加载插件

---

### Q2：运行中途停止了？

**原因**：正常现象，可能是：
- 网络波动
- 达到设定时长
- 页面跳转

**解决**：重新点击"🚀 开始养号"即可

---

### Q3：会被Twitter检测封号吗？

**风险说明**：
- ⚠️ 使用自动化工具违反Twitter服务条款
- ⚠️ 确实存在被检测的风险
- ⚠️ 过度使用会增加风险

**降低风险方法**：
- ✅ 使用保守配置方案
- ✅ 控制运行频率（每天不超过3次）
- ✅ 配合手动操作
- ✅ 仅在测试账号使用

---

### Q4：运行时可以做其他事情吗？

**可以**：
- ✅ 切换到其他标签页
- ✅ 浏览其他网站
- ✅ 最小化浏览器窗口

**不可以**：
- ❌ 关闭Twitter标签页
- ❌ 关闭浏览器
- ❌ 断网

---

### Q5：点赞/关注/转发没有执行？

**原因**：正常现象
- 页面没有可操作内容
- 已经点赞/关注过
- 网络延迟

**处理**：插件会自动跳过，继续执行其他操作

---

### Q6：可以多个账号一起用吗？

**方法**：
- 使用Chrome的多用户功能
- 每个用户单独安装插件
- 各账号独立运行

**不建议**：同一浏览器快速切换账号

---

### Q7：如何查看运行日志？

**方法**：
1. 在Twitter页面按 **F12**
2. 切换到 **Console** 标签
3. 可看到详细运行日志

**日志内容**：
- 🚀 开始信息
- 📊 操作记录
- ✅ 成功信息
- ❌ 错误信息

---

### Q8：如何卸载插件？

**步骤**：
1. 打开 `chrome://extensions/`
2. 找到"推特养号助手"
3. 点击"删除"按钮
4. 确认卸载

### 🔒 安全使用规则

#### ✅ 应该做的
- 在测试账号上使用（强烈建议）
- 使用保守配置参数
- 控制运行频率（每天不超过3次，间隔3小时以上）
- 配合手动操作（运行前后手动浏览）
- 发现异常立即停止使用
- 在正常时段使用（白天）

#### ❌ 不应该做的
- 不要在主账号上使用
- 不要设置过高的数量
- 不要频繁运行（小于3小时间隔）
- 不要24小时持续运行
- 不要在新注册账号上立即使用（等待7-14天）
- 不要分享插件或账号密码

---

### 🎯 账号保护建议

#### 新账号使用前
1. 注册后等待7-14天
2. 手动发几条推文
3. 手动关注一些账号
4. 完善个人资料

#### 使用时配合手动操作
- **运行前**：手动浏览1-2分钟
- **运行后**：手动发1-2条推文
- **每天**：至少3-5次真实手动互动

#### 异常情况处理
- 🔴 收到警告邮件 → 立即停止，等待1-2周
- 🟠 功能受限 → 停止使用，等待恢复
- 🟡 数据异常 → 降低使用频率

---

### 🛡️ 风险提示

| 风险等级 | 说明 | 建议 |
|---------|------|------|
| 🔴 **高风险** | 新账号高频使用、激进配置 | 避免 |
| 🟠 **中风险** | 正常使用但配合不当 | 谨慎 |
| 🟡 **低风险** | 保守配置+手动配合 | 推荐 |
| 🟢 **安全** | 仅浏览模式 | 最安全 |

> ⚠️ **特别提醒**：使用自动化工具违反Twitter服务条款，存在封号风险，请自行承担后果！

---

## 📞 技术支持

### 联系方式
- **作者微信**：hkkj2028
- **脚本下载**：http://ergoubtc.vip/

### 反馈问题时请提供
1. 浏览器版本（chrome://version/）
2. 详细错误信息截图
3. 操作步骤描述

---

## 📝 免责声明

1. **本工具仅供学习研究使用**
2. **使用自动化工具违反Twitter服务条款，可能导致账号封禁**
3. **作者不对使用本工具造成的任何损失负责**
4. **请在充分了解风险的情况下谨慎使用**
5. **本工具不收集任何个人信息，所有数据保存在本地**
6. **禁止用于商业用途**

---

## 🎉 结语

**📌 使用建议**：
- 建议仅在测试账号使用
- 使用保守配置
- 配合手动操作
- 遵守平台规则

**祝您使用愉快！**

---

*最后更新：2024年*  
*版本：v1.0.0*

