// 简单测试脚本 - 在浏览器控制台运行
console.log('🧪 开始测试推特养号助手插件...');

// 测试1: 检查插件是否加载
if (typeof chrome !== 'undefined' && chrome.runtime) {
    console.log('✅ Chrome扩展API可用');
    
    // 测试2: 检查插件状态
    chrome.runtime.sendMessage({action: 'status'}, (response) => {
        if (chrome.runtime.lastError) {
            console.log('❌ 插件通信失败:', chrome.runtime.lastError.message);
        } else {
            console.log('✅ 插件通信成功:', response);
        }
    });
    
    // 测试3: 检查当前页面
    const currentUrl = window.location.href;
    console.log('📍 当前页面:', currentUrl);
    
    if (currentUrl.includes('twitter.com') || currentUrl.includes('x.com')) {
        console.log('✅ 在推特页面，可以使用插件');
    } else {
        console.log('⚠️ 不在推特页面，请访问推特后再使用插件');
    }
    
    // 测试4: 尝试启动机器人
    console.log('🚀 尝试启动机器人...');
    chrome.runtime.sendMessage({action: 'start'}, (response) => {
        if (chrome.runtime.lastError) {
            console.log('❌ 启动失败:', chrome.runtime.lastError.message);
        } else if (response && response.success) {
            console.log('✅ 机器人启动成功:', response.message);
        } else {
            console.log('❌ 启动失败:', response?.message || '未知错误');
        }
    });
    
} else {
    console.log('❌ Chrome扩展API不可用');
}

console.log('🎯 测试完成，请查看上述结果');
