// 生成简单图标的JavaScript代码
// 在浏览器控制台中运行此代码来生成图标

function generateIcon(size) {
    const canvas = document.createElement('canvas');
    canvas.width = size;
    canvas.height = size;
    const ctx = canvas.getContext('2d');
    
    // 创建渐变背景
    const gradient = ctx.createLinearGradient(0, 0, size, size);
    gradient.addColorStop(0, '#1da1f2');
    gradient.addColorStop(1, '#1991db');
    
    // 绘制背景
    ctx.fillStyle = gradient;
    ctx.fillRect(0, 0, size, size);
    
    // 绘制圆角
    ctx.globalCompositeOperation = 'destination-in';
    ctx.beginPath();
    const radius = size * 0.2;
    ctx.roundRect(0, 0, size, size, radius);
    ctx.fill();
    
    // 重置合成模式
    ctx.globalCompositeOperation = 'source-over';
    
    // 绘制推特鸟图标
    ctx.fillStyle = 'white';
    ctx.font = `${size * 0.6}px Arial`;
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText('🐦', size/2, size/2);
    
    return canvas.toDataURL();
}

// 生成所有图标
function generateAllIcons() {
    const sizes = [16, 48, 128];
    sizes.forEach(size => {
        const dataUrl = generateIcon(size);
        const link = document.createElement('a');
        link.download = `icon${size}.png`;
        link.href = dataUrl;
        link.textContent = `下载 icon${size}.png`;
        link.style.display = 'block';
        link.style.margin = '10px 0';
        link.style.padding = '10px';
        link.style.background = '#f0f0f0';
        link.style.borderRadius = '5px';
        link.style.textDecoration = 'none';
        link.style.color = '#333';
        document.body.appendChild(link);
    });
}

// 添加 roundRect 方法
if (!CanvasRenderingContext2D.prototype.roundRect) {
    CanvasRenderingContext2D.prototype.roundRect = function(x, y, width, height, radius) {
        this.beginPath();
        this.moveTo(x + radius, y);
        this.lineTo(x + width - radius, y);
        this.quadraticCurveTo(x + width, y, x + width, y + radius);
        this.lineTo(x + width, y + height - radius);
        this.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
        this.lineTo(x + radius, y + height);
        this.quadraticCurveTo(x, y + height, x, y + height - radius);
        this.lineTo(x, y + radius);
        this.quadraticCurveTo(x, y, x + radius, y);
        this.closePath();
    };
}

console.log('🎨 图标生成器已加载');
console.log('📋 使用方法：');
console.log('1. 运行 generateAllIcons() 生成所有图标');
console.log('2. 点击生成的下载链接');
console.log('3. 将下载的图标文件放到 icons/ 文件夹中');
console.log('4. 重新加载插件');

// 自动生成图标
generateAllIcons();
