// 直接修复脚本 - 解决扩展通信卡住问题
// 在Twitter页面控制台运行此脚本

console.log('🔧 开始直接修复...');

// 1. 强制使用备用评论系统
async function forceFallbackComment() {
    console.log('1️⃣ 强制使用备用评论系统...');
    
    // 查找回复输入框
    const replyInputSelectors = [
        '[data-testid="tweetTextarea_0"]',
        '[data-testid="tweetTextarea_1"]',
        '[data-testid="tweetTextarea_2"]',
        'div[data-testid="tweetTextarea_0"]',
        'div[data-testid="tweetTextarea_1"]',
        'div[data-testid="tweetTextarea_2"]',
        '[contenteditable="true"][data-testid*="tweetTextarea"]',
        'div[contenteditable="true"][role="textbox"]'
    ];
    
    let replyInput = null;
    for (const selector of replyInputSelectors) {
        const inputs = document.querySelectorAll(selector);
        for (const input of inputs) {
            if (input.offsetParent !== null) {
                replyInput = input;
                break;
            }
        }
        if (replyInput) break;
    }
    
    if (!replyInput) {
        console.log('❌ 未找到回复输入框');
        return false;
    }
    
    console.log('✅ 找到回复输入框');
    
    // 使用备用评论
    const fallbackComments = [
        '很有见地的观点！',
        '这个角度很有意思',
        '说得很有道理',
        '值得深思',
        '赞同这个看法',
        '很有启发性',
        '这个观点很新颖',
        '说得对',
        '很有道理',
        '值得关注',
        '这个想法不错',
        '学到了',
        '有道理',
        '确实如此',
        '同意这个观点',
        '很有意思',
        '说得很好',
        '很有道理',
        '赞同',
        '支持'
    ];
    
    const comment = fallbackComments[Math.floor(Math.random() * fallbackComments.length)];
    console.log(`💭 使用备用评论: "${comment}"`);
    
    // 输入评论
    console.log('⌨️ 输入评论...');
    replyInput.focus();
    await new Promise(resolve => setTimeout(resolve, 200));
    
    replyInput.value = '';
    replyInput.dispatchEvent(new Event('input', { bubbles: true }));
    
    // 逐字符输入
    for (let i = 0; i < comment.length; i++) {
        replyInput.value += comment[i];
        replyInput.dispatchEvent(new Event('input', { bubbles: true }));
        await new Promise(resolve => setTimeout(resolve, 50));
    }
    
    // 触发change事件
    replyInput.dispatchEvent(new Event('change', { bubbles: true }));
    await new Promise(resolve => setTimeout(resolve, 1000));
    
    console.log('✅ 评论输入完成');
    return true;
}

// 2. 强制激活发送按钮
async function forceActivateSendButton() {
    console.log('2️⃣ 强制激活发送按钮...');
    
    // 查找发送按钮
    const sendSelectors = [
        '[data-testid="tweetButton"]',
        '[data-testid="tweetButtonInline"]',
        'div[data-testid="tweetButton"]',
        'div[data-testid="tweetButtonInline"]',
        '[role="button"][data-testid*="tweetButton"]'
    ];
    
    let sendButton = null;
    for (const selector of sendSelectors) {
        const buttons = document.querySelectorAll(selector);
        for (const button of buttons) {
            if (button.offsetParent !== null) {
                sendButton = button;
                break;
            }
        }
        if (sendButton) break;
    }
    
    if (!sendButton) {
        console.log('❌ 未找到发送按钮');
        return false;
    }
    
    console.log('✅ 找到发送按钮');
    
    // 强制激活按钮
    console.log('🔄 强制激活发送按钮...');
    
    // 点击按钮
    sendButton.click();
    await new Promise(resolve => setTimeout(resolve, 500));
    
    // 聚焦按钮
    sendButton.focus();
    await new Promise(resolve => setTimeout(resolve, 500));
    
    // 触发事件
    sendButton.dispatchEvent(new MouseEvent('mouseenter', { bubbles: true }));
    await new Promise(resolve => setTimeout(resolve, 200));
    sendButton.dispatchEvent(new MouseEvent('mouseleave', { bubbles: true }));
    await new Promise(resolve => setTimeout(resolve, 200));
    
    // 再次点击
    sendButton.click();
    await new Promise(resolve => setTimeout(resolve, 1000));
    
    console.log('✅ 发送按钮已激活');
    return true;
}

// 3. 主修复流程
async function runDirectFix() {
    console.log('🚀 开始直接修复流程...');
    
    // 强制使用备用评论
    const commentOk = await forceFallbackComment();
    if (!commentOk) {
        console.log('❌ 评论输入失败');
        return false;
    }
    
    // 强制激活发送按钮
    const sendOk = await forceActivateSendButton();
    if (!sendOk) {
        console.log('❌ 发送按钮激活失败');
        return false;
    }
    
    console.log('🎉 直接修复成功！');
    return true;
}

// 4. 测试当前状态
function testCurrentState() {
    console.log('🧪 测试当前状态...');
    
    // 检查回复输入框
    const replyInputs = document.querySelectorAll('[data-testid*="tweetTextarea"]');
    console.log('回复输入框数量:', replyInputs.length);
    
    // 检查发送按钮
    const sendButtons = document.querySelectorAll('[data-testid*="tweetButton"]');
    console.log('发送按钮数量:', sendButtons.length);
    
    // 检查页面URL
    console.log('当前页面URL:', window.location.href);
    
    // 检查是否有内容
    const inputs = document.querySelectorAll('[data-testid*="tweetTextarea"]');
    for (const input of inputs) {
        if (input.value && input.value.trim()) {
            console.log('输入框内容:', input.value);
        }
    }
    
    return { replyInputs: replyInputs.length, sendButtons: sendButtons.length };
}

// 运行修复
runDirectFix().then(result => {
    console.log('🔧 直接修复结果:', result);
    
    if (result) {
        console.log('💡 现在可以继续运行机器人了');
    } else {
        console.log('❌ 直接修复失败，请检查页面状态');
    }
});

// 导出函数供手动调用
window.directFix = {
    testState: testCurrentState,
    forceComment: forceFallbackComment,
    forceSend: forceActivateSendButton,
    runAll: runDirectFix
};

console.log('💡 手动调用: directFix.runAll()');
console.log('💡 测试状态: directFix.testState()');
console.log('💡 强制评论: directFix.forceComment()');
console.log('💡 强制发送: directFix.forceSend()');
