#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
创建简单的插件图标
"""

from PIL import Image, ImageDraw, ImageFont
import os

def create_icon(size, filename):
    """创建指定尺寸的图标"""
    # 创建图像
    img = Image.new('RGBA', (size, size), (0, 0, 0, 0))
    draw = ImageDraw.Draw(img)
    
    # 绘制背景圆形
    margin = size // 10
    draw.ellipse([margin, margin, size-margin, size-margin], 
                 fill=(29, 161, 242, 255))  # 推特蓝色
    
    # 绘制推特鸟图标（使用简单的几何形状）
    center = size // 2
    
    # 绘制鸟的身体（圆形）
    bird_size = size // 3
    draw.ellipse([center - bird_size//2, center - bird_size//2, 
                  center + bird_size//2, center + bird_size//2], 
                 fill=(255, 255, 255, 255))
    
    # 绘制鸟的头部（小圆形）
    head_size = bird_size // 2
    draw.ellipse([center - head_size//2, center - head_size//2 - bird_size//4, 
                  center + head_size//2, center + head_size//2 - bird_size//4], 
                 fill=(255, 255, 255, 255))
    
    # 绘制眼睛
    eye_size = size // 20
    draw.ellipse([center - bird_size//4, center - bird_size//4, 
                  center - bird_size//4 + eye_size, center - bird_size//4 + eye_size], 
                 fill=(0, 0, 0, 255))
    
    # 保存图像
    img.save(filename, 'PNG')
    print(f"✅ 已创建 {filename} ({size}x{size})")

def main():
    """主函数"""
    # 确保icons目录存在
    os.makedirs('icons', exist_ok=True)
    
    # 创建不同尺寸的图标
    create_icon(16, 'icons/icon16.png')
    create_icon(48, 'icons/icon48.png')
    create_icon(128, 'icons/icon128.png')
    
    print("🎉 所有图标创建完成！")
    print("📁 图标文件位置：")
    print("   - icons/icon16.png")
    print("   - icons/icon48.png") 
    print("   - icons/icon128.png")

if __name__ == "__main__":
    main()
