# Arc Testnet BOT 使用说明文档

## 📋 目录
1. [脚本概述](#脚本概述)
2. [功能模块详解](#功能模块详解)
3. [配置文件详解](#配置文件详解)
4. [使用步骤](#使用步骤)
5. [常见问题](#常见问题)
6. [注意事项](#注意事项)

---

## 📖 脚本概述

**Arc Testnet BOT Version 1.1** 是一个自动化工具，用于在 ARC Testnet 网络上执行各种链上操作和领水任务。

### 主要功能
1. **自动完成任务** - 执行链上 GM、部署合约、Mint 域名、Mint NFT 等操作
2. **Circle Faucet 领水** - 自动从 Circle Faucet 领取 USDC 和 EURC 测试代币
3. **自动挂机模式** - 每24小时自动执行领水和完成任务

### 系统要求
- Windows 操作系统（支持 Windows 10/11）
- 网络连接（建议使用代理）
- 有效的权限密钥（primary_key）
- YesCaptcha API Key（用于领水功能）

---

## 🎯 功能模块详解

### 1. 自动完成任务（选项 1）

此功能允许您选择并执行以下链上操作：

#### 1.1 链上 GM
- **功能说明**：在 ARC Testnet 上执行 GM 操作
- **费用**：根据合约动态计算（通常需要少量 USDC）
- **执行逻辑**：
  - 检查账户余额是否足够
  - 检查距离下次 GM 的时间间隔
  - 如果时间间隔已到，自动执行 GM 交易
  - 提交交易哈希到服务器记录

#### 1.2 部署合约
- **功能说明**：部署智能合约到 ARC Testnet
- **费用**：1 USDC
- **执行逻辑**：
  - 检查账户余额（需要至少 1 USDC）
  - 执行部署交易
  - 等待交易确认
  - 提交交易哈希到服务器
- **可配置**：可以设置每个账户的部署次数

#### 1.3 Mint 域名
- **功能说明**：在 ARC 网络上注册域名
- **费用**：1 USDC/域名
- **执行逻辑**：
  - 自动生成随机域名（长度 10-20 字符）
  - 检查账户余额
  - 执行域名注册交易
  - 等待交易确认
- **可配置**：可以设置每个钱包要 mint 的域名数量
- **域名格式**：第一个字符必须是字母，其余可以是字母或数字

#### 1.4 Mint NFT
- **功能说明**：铸造 NFT
- **费用**：0.5 USDC/NFT
- **执行逻辑**：
  - 检查账户余额
  - 执行 NFT 铸造交易
  - 等待交易确认
- **可配置**：可以设置要 mint 的 NFT 数量

#### 1.5 运行所有功能
- **功能说明**：按顺序执行上述所有功能
- **执行顺序**：GM → 部署合约 → Mint 域名 → Mint NFT
- **可配置**：每个功能都可以单独设置执行次数

#### 代理选项
- **使用代理运行**：通过代理服务器执行操作（推荐）
- **不使用代理运行**：直接连接执行
- **旋转无效代理**：如果代理失效，自动切换到下一个代理

#### 执行流程
1. 程序会读取 `config/private_key.txt` 中的所有私钥
2. 对每个账户依次执行选定的操作
3. 每个账户操作完成后等待 3 秒
4. 所有账户处理完成后，等待 24 小时后再次循环执行

---

### 2. Circle Faucet 领水（选项 2）

#### 功能说明
自动从 Circle Faucet（https://faucet.circle.com）领取测试代币。

#### 支持的代币
- **USDC**：Circle USD Coin 测试代币
- **EURC**：Circle Euro Coin 测试代币

#### 执行流程
1. 读取 `config/private_key.txt` 中的所有私钥
2. 为每个私钥生成对应的钱包地址
3. 为每个地址分配代理（如果配置了代理）
4. 自动解决 reCaptcha V2 验证码（使用 YesCaptcha API）
5. 依次请求 USDC 和 EURC 代币
6. 显示请求结果（成功/失败/限流）

#### 代币请求顺序
- 先请求 USDC
- 等待 10 秒
- 再请求 EURC
- 处理下一个账户前等待 3 秒

#### 验证码处理
- 使用 YesCaptcha API 自动解决验证码
- 支持代理模式和无代理模式
- 超时时间：600 秒（10 分钟）

#### 返回信息
成功时会显示：
- 代币类型和数量
- 交易哈希
- 浏览器链接（可在区块链浏览器查看）

---

### 3. 自动挂机领水+完成任务（选项 3）

#### 功能说明
全自动模式，每 24 小时（随机增加 3-10 分钟）自动执行：
1. 先执行领水功能（选项 2）
2. 然后执行自动完成任务（选项 1 的所有功能）

#### 执行周期
- **基础时间**：24 小时
- **随机延迟**：3-10 分钟（避免固定时间执行）
- **总等待时间**：24 小时 + 3-10 分钟

#### 自动模式配置
- **部署次数**：自动设置为 1 次
- **域名数量**：自动设置为 1 个
- **NFT 数量**：自动设置为 1 个
- **代理使用**：自动检测 `config/proxy.txt` 是否存在，存在则使用代理

#### 循环显示
- 显示当前循环次数
- 显示下次执行时间
- 实时倒计时显示剩余等待时间

#### 中断方式
- 按 `Ctrl+C` 可以安全退出自动挂机模式

---

## ⚙️ 配置文件详解

### 1. config.ini（主配置文件）

**文件位置**：与 EXE 文件同一目录

**文件格式**：INI 格式

**必需配置项**：

```ini
[DEFAULT]
primary_key=your_primary_key_here
client_key=your_yescaptcha_client_key_here
```

#### 配置项说明

##### primary_key（必需）
- **说明**：程序权限验证密钥
- **获取方式**：从脚本提供方购买或获取
- **验证机制**：
  - 程序启动时会自动验证
  - 验证服务器：`154.7.177.225:9100`
  - 使用机器硬件 ID 绑定（一机一码）
- **验证状态码**：
  - `401` 或 `407`：密钥已到期或输入错误
  - `403`：绑定机器不是本机，需要在激活机器使用
  - `406`：首次使用，需要绑定设备（输入 yes/Y/y 确认）
  - `409`：当前用户没有脚本权限
  - `408`：激活失败
  - 其他：显示到期时间（格式：YYYY-MM-DD HH:MM:SS）
- **示例**：
  ```ini
  primary_key=user_5a9e9d7c5a
  ```

##### client_key（必需，用于领水功能）
- **说明**：YesCaptcha API 客户端密钥
- **获取方式**：
  1. 访问：https://yescaptcha.com/i/EAQXMP
  2. 注册账号并充值
  3. 在控制台获取 Client Key
- **用途**：用于自动解决 Circle Faucet 的 reCaptcha V2 验证码
- **示例**：
  ```ini
  client_key=d0af3a0c0940452e45ccdcb53a6e473bf541294781402
  ```

#### 完整配置示例

```ini
[DEFAULT]
primary_key=user_5a9e9d7c5a
client_key=d0af3a0c0940452e45ccdcb53a6e473bf541294781402
```

#### 配置注意事项
1. **编码格式**：文件必须使用 UTF-8 编码保存
2. **格式要求**：
   - 必须有 `[DEFAULT]` 部分
   - 每行一个配置项，格式：`key=value`
   - 等号前后可以有空格，但建议不要有
   - 值中不要包含等号（除非是配置值的一部分）
3. **路径要求**：文件必须与 EXE 在同一目录
4. **权限验证**：如果 `primary_key` 配置错误或过期，程序将无法启动

---

### 2. config/private_key.txt（私钥文件）

**文件位置**：`config/private_key.txt`（相对于 EXE 文件）

**文件格式**：纯文本，每行一个私钥

**必需性**：必需（所有功能都需要）

#### 配置方法

1. **创建目录**：
   - 在 EXE 文件所在目录创建 `config` 文件夹
   - 如果目录不存在，程序会报错

2. **创建文件**：
   - 在 `config` 目录下创建 `private_key.txt` 文件

3. **添加私钥**：
   - 每行输入一个私钥（64 个十六进制字符，通常以 0x 开头，但程序会自动处理）
   - 不要有空行或注释
   - 私钥之间用换行符分隔

#### 格式示例

```
0x1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef
0xabcdef1234567890abcdef1234567890abcdef1234567890abcdef1234567890
0x9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba
```

或者（不带 0x 前缀）：

```
1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef
abcdef1234567890abcdef1234567890abcdef1234567890abcdef1234567890
9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba
```

#### 注意事项
1. **安全性**：
   - ⚠️ **私钥文件包含敏感信息，请妥善保管**
   - 不要将私钥文件分享给他人
   - 建议定期备份私钥文件
   - 不要将私钥文件上传到公共代码仓库

2. **格式要求**：
   - 每行只能有一个私钥
   - 私钥必须是有效的以太坊格式私钥（64 个十六进制字符）
   - 空行会被自动忽略
   - 行首和行尾的空格会被自动去除

3. **数量限制**：
   - 理论上没有数量限制
   - 建议每次处理不超过 100 个账户（避免执行时间过长）

4. **验证**：
   - 程序会自动验证私钥格式
   - 无效的私钥会被跳过并显示错误信息

---

### 3. config/proxy.txt（代理文件）

**文件位置**：`config/proxy.txt`（相对于 EXE 文件）

**文件格式**：纯文本，每行一个代理

**必需性**：可选（但强烈推荐使用）

#### 支持的代理格式

##### HTTP/HTTPS 代理
```
http://username:password@host:port
https://username:password@host:port
http://host:port
https://host:port
```

##### SOCKS 代理
```
socks4://host:port
socks5://host:port
socks4://username:password@host:port
socks5://username:password@host:port
```

##### 简化格式（自动添加 http:// 前缀）
```
host:port
username:password@host:port
```

#### 配置示例

```
http://user:pass@192.168.1.100:8080
https://proxy.example.com:3128
socks5://127.0.0.1:1080
192.168.1.101:8080
user:pass@proxy.example.com:3128
```

#### 代理分配机制

1. **自动分配**：
   - 程序会为每个账户自动分配一个代理
   - 代理按顺序循环使用
   - 每个账户固定使用一个代理（不会在运行过程中更换）

2. **代理轮换**：
   - 如果选择"旋转无效代理"，当代理连接失败时会自动切换到下一个代理
   - 否则，代理失败时会跳过该账户

3. **代理检测**：
   - 程序会先检测代理是否可用
   - 只有可用的代理才会被使用

#### 注意事项
1. **代理质量**：
   - 建议使用稳定、快速的代理
   - 代理延迟过高会影响执行效率
   - 代理不稳定可能导致交易失败

2. **代理数量**：
   - 建议代理数量 ≥ 账户数量
   - 如果代理数量少于账户数量，代理会循环使用
   - 多个账户使用同一代理可能增加被限流的风险

3. **代理类型**：
   - HTTP/HTTPS 代理：适用于大多数场景
   - SOCKS 代理：支持更完整的协议，但可能速度较慢

4. **代理认证**：
   - 如果代理需要用户名和密码，必须在配置中包含
   - 格式：`username:password@host:port`

5. **不使用代理**：
   - 如果不创建 `config/proxy.txt` 文件，程序将直接连接
   - 直接连接可能被限流或封禁 IP

---

## 🚀 使用步骤

### 第一步：准备配置文件

1. **创建目录结构**：
   ```
   项目目录/
   ├── Arc_Testnet_BOT.exe
   ├── config.ini
   └── config/
       ├── private_key.txt
       └── proxy.txt（可选）
   ```

2. **配置 config.ini**：
   - 打开 `config.ini` 文件
   - 设置 `primary_key`（从提供方获取）
   - 设置 `client_key`（从 YesCaptcha 获取）
   - 保存文件

3. **配置 private_key.txt**：
   - 在 `config` 目录下创建 `private_key.txt`
   - 每行添加一个私钥
   - 保存文件

4. **配置 proxy.txt（可选但推荐）**：
   - 在 `config` 目录下创建 `proxy.txt`
   - 每行添加一个代理
   - 保存文件

### 第二步：运行程序

1. **双击运行** `Arc_Testnet_BOT.exe`

2. **权限验证**：
   - 程序会自动验证 `primary_key`
   - 如果是首次使用，会提示绑定设备（输入 `yes` 或 `Y` 或 `y`）
   - 验证成功后进入主菜单

3. **选择功能**：
   ```
   ==================================================
   请选择:
   1. 自动完成任务
   2. Circle Faucet 领水
   3. 自动挂机领水+完成任务
   4. 退出
   ==================================================
   ```
   - 输入 `1`、`2`、`3` 或 `4` 选择功能

### 第三步：执行功能

#### 如果选择 1（自动完成任务）

1. **选择操作类型**：
   ```
   选择选项:
   1. 链上GM
   2. 部署合约
   3. Mint域名
   4. Mint NFT
   5. 运行所有功能
   ```
   - 输入 `1-5` 选择操作

2. **配置参数**（根据选择的操作）：
   - **部署合约**：输入部署次数（例如：`1`）
   - **Mint 域名**：输入每个钱包要 mint 的域名数量（例如：`1`）
   - **Mint NFT**：输入要 mint 的 NFT 数量（例如：`1`）

3. **选择代理**：
   ```
   1. 使用代理运行
   2. 不使用代理运行
   ```
   - 输入 `1` 或 `2`

4. **代理轮换**（如果选择了使用代理）：
   ```
   旋转无效代理? [y/n]
   ```
   - 输入 `y` 或 `n`

5. **开始执行**：
   - 程序会自动处理所有账户
   - 显示每个账户的执行状态
   - 所有账户处理完成后，等待 24 小时后再次循环

#### 如果选择 2（Circle Faucet 领水）

1. **自动执行**：
   - 程序会自动读取私钥
   - 为每个地址请求 USDC 和 EURC
   - 显示请求结果

2. **无需额外配置**：
   - 所有配置已在配置文件中完成

#### 如果选择 3（自动挂机模式）

1. **自动执行**：
   - 程序会自动执行领水功能
   - 然后执行所有自动完成任务
   - 等待 24 小时（+ 3-10 分钟随机延迟）后再次执行

2. **显示信息**：
   - 显示当前循环次数
   - 显示下次执行时间
   - 实时倒计时

3. **退出方式**：
   - 按 `Ctrl+C` 可以安全退出

---

## ❓ 常见问题

### Q1: 程序启动时提示"无法读取config.ini配置文件"
**A**: 
- 检查 `config.ini` 文件是否与 EXE 在同一目录
- 检查文件编码是否为 UTF-8
- 检查文件格式是否正确（必须有 `[DEFAULT]` 部分）

### Q2: 权限验证失败，显示"已到期/输入错误"
**A**: 
- 检查 `primary_key` 是否正确
- 联系提供方确认密钥是否过期
- 确认密钥是否已绑定到当前设备

### Q3: 权限验证失败，显示"绑定机器不是为本机"
**A**: 
- 密钥已绑定到其他设备
- 需要在原激活设备上使用
- 或联系提供方重新购买/解绑

### Q4: 首次使用时提示绑定设备
**A**: 
- 这是正常的安全机制
- 输入 `yes`、`Y` 或 `y` 确认绑定
- 绑定后该密钥只能在此设备使用

### Q5: 领水功能提示"client_key 为空"
**A**: 
- 检查 `config.ini` 中是否配置了 `client_key`
- 确认 `client_key` 格式正确（没有多余空格）
- 重新获取 YesCaptcha 的 Client Key

### Q6: 验证码解决失败
**A**: 
- 检查 YesCaptcha 账户余额是否充足
- 检查 `client_key` 是否正确
- 检查网络连接是否正常
- 尝试使用代理

### Q7: 交易失败，提示"余额不足"
**A**: 
- 检查账户 USDC 余额
- 确保余额足够支付交易费用和操作费用
- 先使用领水功能获取测试代币

### Q8: 代理连接失败
**A**: 
- 检查代理格式是否正确
- 检查代理是否需要认证（用户名密码）
- 测试代理是否可用
- 尝试更换其他代理

### Q9: 程序执行很慢
**A**: 
- 检查网络连接速度
- 检查代理延迟
- 减少同时处理的账户数量
- 优化代理质量

### Q10: 域名 Mint 失败
**A**: 
- 检查账户余额（需要 1 USDC）
- 检查域名是否已被注册
- 程序会自动生成随机域名，但仍有重复可能
- 可以尝试减少域名数量或增加账户余额

### Q11: NFT Mint 失败
**A**: 
- 检查账户余额（需要 0.5 USDC）
- 检查合约是否正常
- 检查网络连接

### Q12: 如何安全退出程序
**A**: 
- 在主菜单选择 `4` 退出
- 在自动挂机模式按 `Ctrl+C` 退出
- 不要直接关闭窗口（可能导致数据丢失）

### Q13: 程序显示"私钥无效"
**A**: 
- 检查私钥格式是否正确（64 个十六进制字符）
- 确认私钥没有多余空格或换行符
- 确认私钥是有效的以太坊格式私钥

### Q14: 如何查看交易详情
**A**: 
- 程序会显示交易哈希
- 使用 ARC 区块链浏览器查看：https://testnet.arcscan.app/tx/{交易哈希}
- 程序也会显示浏览器链接

### Q15: 自动挂机模式可以运行多久
**A**: 
- 理论上可以无限运行
- 建议定期检查程序状态
- 确保电脑不会休眠或关机
- 建议使用 VPS 或云服务器长期运行

---

## ⚠️ 注意事项

### 安全注意事项

1. **私钥安全**：
   - ⚠️ **永远不要将私钥分享给任何人**
   - ⚠️ **不要将私钥文件上传到公共平台**
   - ⚠️ **定期备份私钥文件到安全位置**
   - ⚠️ **使用完毕后建议删除私钥文件**

2. **权限密钥安全**：
   - 不要将 `primary_key` 分享给他人
   - 密钥绑定设备后无法在其他设备使用

3. **代理安全**：
   - 使用可信的代理服务
   - 不要使用来源不明的代理
   - 代理可能记录您的网络流量

### 使用注意事项

1. **网络要求**：
   - 需要稳定的网络连接
   - 建议使用代理避免 IP 被封
   - 网络不稳定可能导致交易失败

2. **余额要求**：
   - 确保账户有足够的 USDC 余额
   - GM 操作：需要少量 USDC（动态计算）
   - 部署合约：需要 1 USDC
   - Mint 域名：需要 1 USDC/域名
   - Mint NFT：需要 0.5 USDC/NFT
   - Gas 费用：需要少量 USDC（约 0.001 USDC）

3. **执行时间**：
   - 每个操作需要等待交易确认
   - ARC 网络确认速度较快（通常几秒到几分钟）
   - 大量账户处理可能需要较长时间

4. **限流问题**：
   - Circle Faucet 可能有请求频率限制
   - 如果被限流，需要等待一段时间后重试
   - 使用代理可以降低被限流的风险

5. **程序稳定性**：
   - 建议在稳定的环境中运行
   - 避免频繁中断程序
   - 定期检查程序运行状态

6. **数据备份**：
   - 定期备份配置文件
   - 记录重要的交易哈希
   - 保存程序运行日志（如果有）

### 技术限制

1. **网络限制**：
   - 仅支持 ARC Testnet 网络
   - 不支持主网操作

2. **功能限制**：
   - 域名自动生成，无法自定义
   - NFT 数量固定为 1（每次 Mint）
   - 代理轮换需要手动启用

3. **兼容性**：
   - 仅支持 Windows 系统
   - 需要管理员权限（某些操作）

---

## 📞 技术支持

### 联系方式
- **脚本下载**：http://ergoubtc.vip/
- **电报**：https://t.me/dingxiaoguai
- **微信**：hkkj2028

### 获取帮助
- 遇到问题时，请先查看本文档的"常见问题"部分
- 如果问题仍未解决，请联系技术支持
- 提供详细的错误信息和日志有助于快速解决问题

---

## 📝 更新日志

### Version 1.1
- ✅ 集成 Circle Faucet 领水功能
- ✅ 支持自动解决 reCaptcha V2 验证码
- ✅ 添加自动挂机模式
- ✅ 优化权限验证机制
- ✅ 改进配置文件读取逻辑
- ✅ 支持代理自动分配和轮换

---

## 📄 许可证

Copyright (c) 2025
All Rights Reserved

---

**最后更新**：2025年1月

**文档版本**：1.0

