## 概述

这是一个“网页自动打字并自动提交”的脚本。它会在包含“Submit to Leaderboard”“Play Again”按钮、以及以白色字体显示待输入单词的网页上，自动：
- 识别当前需要输入的单词
- 模拟真人逐字输入（带随机延迟）
- 点击提交，自动再次开始
- 循环执行，直到你手动停止

脚本源码在文件：`js脚本.txt`（基础版）和 `js脚本-优化版.txt`（推荐）

---

## 作者信息
- **作者**：@ergoubtc
- **推特**：[@https://x.com/ergoubtc](https://x.com/ergoubtc)
- **微信**：spdh0321
- **更多免费脚本**：[http://ergoubtc.vip/](http://ergoubtc.vip/)

---

## 优化版脚本（推荐）

除了基础版 `js脚本.txt`，我们还提供了功能更强大的 `js脚本-优化版.txt`：

### 优化版新增功能
- **可配置参数**：在脚本顶部 `CONFIG` 中轻松调整所有设置
- **多种输入支持**：兼容 `input`、`textarea`、`contenteditable` 元素
- **智能按钮识别**：支持 `button`、`[role="button"]`、`a` 标签，大小写不敏感
- **热键控制**：按 `ESC` 键可暂停/继续脚本运行
- **更真实的行为**：逐字随机延迟、完整的事件模拟
- **真人化错误输入**：模拟真实打字错误并自动修正
- **自动滚动**：确保按钮在可视区域内再点击
- **容错机制**：多重回退策略，提高成功率

### 优化版使用方法
1. 打开目标网页
2. 按 F12 → Console
3. 复制 `js脚本-优化版.txt` 全部内容到控制台，回车运行
4. 按 `ESC` 可随时暂停/继续
5. 在控制台输入 `window.AUTO_TYPE_STOP = true` 可完全停止

### 优化版配置说明
在脚本顶部的 `CONFIG` 对象中可以调整：

```javascript
const CONFIG = {
    // 输入框选择器（按优先级顺序）
    inputSelectors: [
        'input[type="text"]',
        'textarea', 
        '[contenteditable="true"]'
    ],
    
    // 单词显示区域选择器
    wordSelector: 'div[class*="text-"]',
    
    // 当前单词的颜色（用于识别）
    activeWordColor: 'rgb(255, 255, 255)',
    
    // 按钮文案（大小写不敏感）
    submitText: 'Submit to Leaderboard',
    playAgainText: 'Play Again',
    
    // 输入速度（毫秒）
    perCharDelayMinMs: 80,    // 每字符最小延迟
    perCharDelayMaxMs: 100,   // 每字符最大延迟
    
    // 其他延迟设置
    afterWordSpaceDelayMs: 200,    // 输入空格后等待
    afterSubmitDelayMs: 2000,      // 提交后等待
    afterPlayAgainDelayMs: 3000,   // 重新开始后等待
    
    // 真人化错误输入配置
    humanizeErrors: {
        enabled: true,                    // 是否启用错误输入
        errorRate: 0.15,                  // 错误率 15%
        typoRate: 0.08,                   // 拼写错误率 8%
        doubleCharRate: 0.05,             // 重复字符率 5%
        skipCharRate: 0.03,               // 漏字符率 3%
        wrongCharRate: 0.04,              // 错误字符率 4%
        correctionDelayMinMs: 500,        // 修正前最小延迟
        correctionDelayMaxMs: 1500,       // 修正前最大延迟
        backspaceDelayMinMs: 50,          // 退格键最小延迟
        backspaceDelayMaxMs: 100,         // 退格键最大延迟
        maxCorrectionAttempts: 3          // 最大修正尝试次数
    },
    
    // 控制选项
    maxRounds: Infinity,           // 最大轮数（设为数字可限制）
    autoDoubleTabWhenSingleWord: true,  // 是否自动双Tab
    debug: true                    // 是否显示调试信息
};
```

### 常见配置调整
- **输入速度**：调整 `perCharDelayMinMs` 和 `perCharDelayMaxMs`
- **按钮文案**：修改 `submitText` 和 `playAgainText` 为实际按钮文字
- **颜色识别**：如果页面不是白色文字，修改 `activeWordColor`
- **限制轮数**：设置 `maxRounds: 10` 只运行10轮
- **关闭调试**：设置 `debug: false` 减少控制台输出
- **真人化错误**：调整 `humanizeErrors` 配置，让输入更真实

### 真人化错误输入功能
脚本现在支持模拟真实人类的打字错误行为：

- **拼写错误**：模拟键盘相邻键的误按（如 'a' 误按为 's'）
- **重复字符**：偶尔重复输入同一个字符
- **漏字符**：跳过某些字符不输入
- **错误字符**：输入完全错误的字符
- **自动修正**：发现错误后，模拟退格删除并重新输入正确内容

**错误类型配置**：
- `errorRate: 0.15` - 总体错误率 15%
- `typoRate: 0.08` - 拼写错误率 8%
- `doubleCharRate: 0.05` - 重复字符率 5%
- `skipCharRate: 0.03` - 漏字符率 3%
- `wrongCharRate: 0.04` - 错误字符率 4%

**修正行为配置**：
- `correctionDelayMinMs/MaxMs` - 修正前的思考时间
- `backspaceDelayMinMs/MaxMs` - 退格键的输入速度
- `enabled: false` - 可完全关闭此功能

---

## 使用前准备
- 浏览器：推荐 Chrome（最新版）或者指纹浏览器
- 目标网页：页面上需要有以下元素（英文界面也可以）
  - 输入框：通常是 `input[type="text"]`
  - 按钮：`Submit to Leaderboard` 和 `Play Again`
  - 显示待输入单词的区域（白色文字）

---

## 快速开始（最简单的方式）
1. 打开目标网页。
2. 按键盘 F12 打开开发者工具，切换到 Console（控制台）标签。
3. 打开本项目中的 `js脚本.txt`，复制全部内容。
4. 回到浏览器 Console，将脚本粘贴进去，按回车运行。
5. 看到控制台输出“📝 正在输入: xxx”等日志，表示已开始自动运行。
6. 想停止：刷新页面或关闭该标签页即可。

提示：若 Console 提示需要输入“allow pasting”，请先在控制台输入 `allow pasting` 回车，再粘贴脚本。

---

## 详细步骤（小白友好）
- 第1步：确保页面上能手动输入并有可见的单词提示；若英文界面能看到“Submit to Leaderboard / Play Again”，更好。
- 第2步：F12 → Console。若控制台有报错红字，先清空（右键 Clear console）。
- 第3步：把 `js脚本.txt` 的全部内容原封不动粘贴进去，按回车。
- 第4步：等待 1-3 秒，脚本会自动聚焦输入框、逐字输入、提交，并自动重新开始。
- 第5步：如果长时间无反应，见“常见问题”。

---

## 如何停止脚本
- 刷新网页，或
- 关闭当前标签页，或
- 在 Console 里右上角“中断脚本/清空并断开”（不同浏览器按钮位置略有差异）。

---

## 常见问题（FAQ）
- 看不到任何动作/无反应？
  - 确认页面上确实有 `input[type="text"]` 输入框。
  - 页面按钮文案是否是 `Submit to Leaderboard` 和 `Play Again`？若不是，脚本也能运行，但自动提交逻辑可能失效。
  - 站点可能使用了不同的样式，脚本默认寻找白色文字 `rgb(255, 255, 255)`。若你页面为深色/浅色主题，颜色不同，见下方“自定义”。
  - 等待更久一点；网络或页面卡顿会拖慢动作。

- 控制台提示“allow pasting”或阻止粘贴？
  - 在 Console 输入 `allow pasting` 回车，然后再次粘贴脚本。

- 只输入一次就不动了？
  - 脚本会尝试点击“Submit to Leaderboard”，再点“Play Again”并继续。如果页面按钮文案不同或按钮不可见，可能无法循环。你可以手动点一次“Play Again”，让页面回到初始状态后脚本会继续。

- 误点到其他地方导致失焦？
  - 脚本会尝试重新聚焦并继续输入；若仍不行，刷新后重新运行脚本。

---

## 自定义（可选，高阶一点）
如果你的页面与默认选择器或颜色不一致，可以按需修改以下位置：

- 输入框选择器：默认 `input[type="text"]`
  - 若你页面用的是 `textarea` 或自定义输入组件，需要把脚本中对应的 `querySelector('input[type="text"]')` 改为实际选择器。

- 目标单词识别：默认根据“白色文字 + 非空文本”判断
  - 颜色判断在脚本中使用 `window.getComputedStyle(el).color === 'rgb(255, 255, 255)'`
  - 若你页面不是白色，可将 `rgb(255, 255, 255)` 改为实际颜色（例如 `rgb(0, 0, 0)` 代表黑色）。

- 输入速度（防反作弊，尽量更像人）：
  - 脚本内按“每个字符 80-100ms 随机延迟”输入。可把 `80 + Math.random() * 20` 调大到 `120 + Math.random() * 60` 等更稳妥的值。

- 关键按钮文案：
  - 如果你页面按钮不是英文，可将 `findButton('Submit to Leaderboard')`、`findButton('Play Again')` 里的文本改为实际文案。

修改方法：用任意文本编辑器打开 `js脚本.txt`，搜索上述关键词并替换，保存后再复制到 Console 运行。

---

## 版本对比
| 功能 | 基础版 | 优化版 |
|------|--------|--------|
| 使用方法 | 简单 | 简单 |
| 可配置性 | 需修改代码 | 顶部配置 |
| 输入兼容性 | input | input/textarea/contenteditable |
| 按钮识别 | 精确匹配 | 模糊匹配+多种元素 |
| 热键控制 | 无 | ESC暂停/继续 |
| 容错能力 | 基础 | 增强 |
| 调试信息 | 固定 | 可开关 |

---

## 进阶用法：油猴脚本（Tampermonkey）
若你希望打开指定网页后自动运行脚本：
- 安装浏览器扩展 Tampermonkey。
- 新建脚本，将 `// ==UserScript==` 头部按你的目标网址配置好 `@match`。
- 把 `js脚本.txt` 或 `js脚本-优化版.txt` 的全部内容粘贴到脚本主体中保存。
- 访问匹配的网址，脚本会自动执行（如需手动触发，可在面板中开/关）。

提示：不同站点的 DOM 结构有差异，若自动不生效，请参考“自定义”一节调整选择器和按钮文本。

---

## 风险与合规提示
- 某些网站禁止自动化操作，可能违反使用条款；请仅在你有权限的页面使用，并自行承担风险。
- 建议降低输入速度、加入随机性，避免高频与可疑行为。
- 不要在涉及账号、支付或敏感数据的页面运行此类脚本。

---

## 免责声明
本脚本仅用于学习与研究前端自动化。使用者需自行评估和承担一切风险与后果。作者不对因使用该脚本造成的任何损失负责。

---

## 联系方式
- **推特**：[@https://x.com/ergoubtc](https://x.com/ergoubtc)
- **微信**：spdh0321
- **更多免费脚本**：[http://ergoubtc.vip/](http://ergoubtc.vip/)
