# Backpack网格交易机器人 - 详细使用教程

## 📋 目录
1. [软件简介](#软件简介)
2. [功能特点](#功能特点)
3. [安装与启动](#安装与启动)
4. [账号配置详解](#账号配置详解)
5. [IP代理配置](#ip代理配置)
6. [交易参数设置](#交易参数设置)
7. [网格策略配置](#网格策略配置)
8. [GUI监控界面](#gui监控界面)
9. [常见问题解答](#常见问题解答)
10. [风险提示](#风险提示)

---

## 🚀 软件简介

Backpack网格交易机器人是一款专为Backpack交易所设计的自动化交易工具，支持多账户管理、智能网格交易、实时监控等功能。

**作者信息：**
- 作者微信：spdh0321
- 推特：ergoubtc
- 脚本下载：http://ergoubtc.vip/

---

## ✨ 功能特点

### 核心功能
- **智能网格交易**：自动在设定价格区间内挂买卖单
- **多账户管理**：支持同时管理多个交易账户
- **实时监控**：GUI界面实时显示交易状态和盈亏
- **自动补充**：成交后自动补充新的挂单
- **风险控制**：支持资金管理和止损设置

### 交易模式
- **网格模式**：智能网格交易，适合震荡行情
- **普通模式**：传统买卖交易，适合趋势行情

---


## 🔧 账号配置详解

### 1. accounts.json 配置文件

```json
[
  {
    "apikey": "你的API密钥1",
    "apisecret": "你的API密钥1的Secret",
    "ip": "http://用户名:密码@IP:端口"
  },
  {
    "apikey": "你的API密钥2", 
    "apisecret": "你的API密钥2的Secret",
    "ip": "http://用户名:密码@IP:端口"
  }
]
```

### 2. API密钥获取步骤

1. **登录Backpack交易所**
   - 访问 https://backpack.exchange/join/5b4d1649-e059-462a-8b42-b52074e23c16
   - 注册并完成KYC验证

2. **创建API密钥**
   访问 https://backpack.exchange/portfolio/settings/api-keys。

   - 点击"创建新API密钥"
   - 设置API名称（如：网格交易机器人）
   - 选择权限：**必须勾选交易权限**
   - 设置IP白名单（可选）

3. **保存密钥信息**
   - 复制API Key和Secret
   - **重要**：Secret只显示一次，请妥善保存

### 3. 多账户配置

```json
[
  {
    "apikey": "K1wTn0Ba1S0gKPY1WuvRWX4SVuSG4FAHYxpSi2Zfe8=",
    "apisecret": "IN6ZlHQEcVgPf0fMOQ4Hd0tOH5o2sAMsFoYlpT9xU=",
    "ip": "http://user1:pass1@192.168.1.100:8080"
  },
  {
    "apikey": "hVHrOwLzoVqVWXm+9OyLphmc4yRicvyDvvZEZVyrq4=",
    "apisecret": "26hEzhSiJCrfstPRdh50iz+Lbe/pr9w6k8P7pT6xDo=",
    "ip": "http://user2:pass2@192.168.1.101:8080"
  }
]
```

**配置说明：**
- 每个账户需要独立的API密钥
- 支持配置不同的代理IP
- 程序会自动轮换使用所有账户

---

## 🌐 IP代理配置

### 1. 代理IP格式

```
http://用户名:密码@IP地址:端口
```

**示例：**
```
http://proxy_user:proxy_pass@64.137.90.159:5779
```

### 2. 代理IP获取

**推荐代理服务商：**
- 住宅IP代理
- 数据中心IP代理
- 移动IP代理

**配置要求：**
- 支持HTTP/HTTPS协议
- 连接稳定，延迟低
- 支持长时间连接

### 3. 代理配置示例

```json
{
  "apikey": "你的API密钥",
  "apisecret": "你的API密钥Secret",
  "ip": "http://prhjzaxu:z476k596m8b9@64.137.90.159:5779"
}
```

### 4. 代理测试

程序启动时会自动测试代理连接：
- ✅ 连接成功：显示代理IP信息
- ❌ 连接失败：显示错误信息，建议更换代理

---

## ⚙️ 交易参数设置

### 1. config.ini 配置文件

```ini
[DEFAULT]
primary_key=你的权限密钥          ; 必填：程序授权密钥
amount=100                      ; 普通模式：每次交易金额(USDC)
number=5                        ; 普通模式：交易轮数
time=(4,150)                    ; 普通模式：轮次间隔(秒)
mode=grid                       ; 交易模式：grid/normal
grid_symbol=SOL_USDC            ; 网格交易对
grid_lower=215                  ; 网格下限价格
grid_upper=235                  ; 网格上限价格
grid_levels=10                  ; 网格层数
grid_total_usdc=160             ; 网格总资金(USDC)
grid_reserve_sol=0.010          ; 预留SOL数量
```

### 2. 参数详解

#### 基础参数
- **primary_key**：程序授权密钥，联系作者获取
- **mode**：交易模式
  - `grid`：网格交易模式
  - `normal`：普通交易模式

#### 普通模式参数
- **amount**：每次交易金额（USDC）
- **number**：交易轮数
- **time**：轮次间隔时间范围（秒）

#### 网格模式参数
- **grid_symbol**：交易对（如：SOL_USDC）
- **grid_lower**：网格下限价格
- **grid_upper**：网格上限价格
- **grid_levels**：网格层数（建议8-12层）
- **grid_total_usdc**：用于网格交易的总资金
- **grid_reserve_sol**：预留的SOL数量

---

## 📊 网格策略配置

### 1. 网格策略原理

网格交易是一种量化交易策略，在设定的价格区间内自动挂买卖单：

```
价格区间：215 - 235 USDC
网格层数：10层
价格间距：2 USDC

买单：213, 215, 217, 219, 221, 223
卖单：225, 227, 229, 231, 233, 235
```

### 2. 参数设置建议

#### 价格区间设置
```ini
# 保守策略（适合新手）
grid_lower=200
grid_upper=250
grid_levels=10

# 激进策略（适合有经验用户）
grid_lower=210
grid_upper=230
grid_levels=8
```

#### 资金分配
```ini
# 总资金200U的分配建议
grid_total_usdc=160    ; 80%用于网格交易
grid_reserve_sol=0.01  ; 预留1%的SOL
# 剩余40U作为备用资金
```

### 3. 网格策略优化

#### 动态调整
- 程序会自动检测价格是否超出区间
- 超出时会自动调整网格范围
- 支持手动调整参数

#### 风险控制
- 设置合理的价格区间
- 控制单笔交易金额
- 预留足够的备用资金

---

## 🖥️ GUI监控界面

### 1. 界面布局

```
┌─────────────────────────────────────────────────────────┐
│                Backpack网格交易监控面板                    │
│        作者微信：spdh0321 | 推特：ergoubtc                │
├─────────────┬─────────────┬─────────────────────────────┤
│   账号状态   │   挂单信息   │        交易统计              │
│             │             │                            │
│ 账号1:      │ 买单 (6)    │ 总账号数: 2                │
│ 价格: $218  │ 卖单 (4)    │ 总市值: $1,234.56          │
│ SOL: 1.23   │             │ 总盈亏: +$12.34            │
│ USDC: 100   │             │ 平均收益率: +1.00%         │
│ 盈亏: +$5   │             │                            │
│             │             │        实时日志              │
│ 账号2:      │             │ [10:30:15] 挂单成功        │
│ 价格: $218  │             │ [10:30:20] 成交通知        │
│ SOL: 0.87   │             │ [10:30:25] 补充挂单        │
│ USDC: 150   │             │                            │
│ 盈亏: +$7   │             │                            │
└─────────────┴─────────────┴─────────────────────────────┘
```

### 2. 功能按钮

- **开始监控**：启动实时监控
- **停止监控**：停止监控
- **清空日志**：清空日志显示
- **刷新挂单**：手动刷新挂单信息

### 3. 实时信息

#### 账号状态
- 当前市场价格
- SOL和USDC余额
- 总市值
- 实时盈亏

#### 挂单信息
- 买单数量和价格
- 卖单数量和价格
- 距离成交百分比

#### 交易统计
- 总账号数
- 总市值
- 总盈亏
- 平均收益率

---

## ❓ 常见问题解答

### Q1: 程序启动后显示"已到期/输入错误"
**A:** 权限密钥已过期，请联系作者获取新的密钥

### Q2: 挂单失败，显示"Insufficient funds"
**A:** 账户余额不足，请检查：
- USDC余额是否足够
- SOL余额是否足够
- 预留资金设置是否合理

### Q3: 代理IP连接失败
**A:** 检查代理配置：
- IP地址和端口是否正确
- 用户名和密码是否正确
- 代理服务是否正常

### Q4: 网格挂单不完整
**A:** 可能原因：
- 资金分配不合理
- 价格区间设置过小
- 网络连接不稳定

### Q5: GUI界面显示异常
**A:** 解决方案：
- 检查控制台编码设置
- 重启程序
- 更新到最新版本

---

## ⚠️ 风险提示

### 1. 交易风险
- **市场风险**：加密货币价格波动剧烈
- **技术风险**：程序可能存在bug
- **流动性风险**：市场流动性不足时可能无法成交

### 2. 资金安全
- **API安全**：妥善保管API密钥
- **资金管理**：不要投入超过承受能力的资金
- **分散投资**：建议分散到多个账户

### 3. 使用建议
- **小额测试**：先用小额资金测试
- **监控运行**：定期检查程序运行状态
- **及时调整**：根据市场情况调整参数

### 4. 免责声明
- 本软件仅供学习和研究使用
- 使用者需自行承担交易风险
- 作者不对任何损失负责

---

## 📞 技术支持

**联系方式：**
- 作者微信：spdh0321
- 推特：ergoubtc
- 脚本下载：http://ergoubtc.vip/

**支持时间：**
- 工作日：9:00-18:00
- 周末：10:00-16:00

**常见问题：**
- 优先查看本教程
- 检查配置文件格式
- 确认网络连接正常

---

## 📝 更新日志

### v1.0 (2025-09-11)
- ✅ 初始版本发布
- ✅ 支持网格交易
- ✅ 支持多账户管理
- ✅ 支持GUI监控界面
- ✅ 支持代理IP配置

---

**祝您交易顺利！** 🚀
